import oracle.xml.parser.schema.*;
import oracle.xml.parser.v2.*;
import oracle.xml.util.XMLUtil;
import java.net.*;
import java.io.*;
import org.w3c.dom.*;
import java.util.*;
 
public class xsddom
{
   public static void main(String[] args) throws Exception 
   {
      if (args.length != 2)
      {
         System.out.println("Usage: java xsddom <schema_file> <xml_file>");
         return;
      }
 
      XSDBuilder builder = new XSDBuilder();
      URL    url =  XMLUtil.createURL(args[0]);       
 
      // Build XML Schema Object
      XMLSchema schemadoc = (XMLSchema)builder.build(url);      
      process(args[1], schemadoc);
   }
 
   public static void process(String xmlURI, XMLSchema schemadoc)
   throws Exception 
   {
      DOMParser dp  = new DOMParser();
      URL       url = XMLUtil.createURL (xmlURI);
      
      dp.setPreserveWhitespace (true);
      dp.setValidationMode(XMLParser.NONVALIDATING);
      dp.setErrorStream (System.out);
      try 
      {
         System.out.println("Parsing "+xmlURI);
         dp.parse (url);
         XMLError err;
         XMLDocument doc = dp.getDocument();
         try
         {
            err = new XMLError();
            XSDValidator validator = new XSDValidator();
            validator.setError(err);
            validator.setXMLProperty(XSDNode.FIXED_SCHEMA, schemadoc);
            XMLElement root = (XMLElement)doc.getDocumentElement(); 
            XMLElement copy = (XMLElement)root.validateContent(validator, true);
            copy.print(System.out);
         }
         catch (Exception e)
         {
            System.out.println ("Schema Validation Exception: " + e.getMessage());
            return;
         }
         if (err.getFirstError() >= -1) //handle errors
            err.flushErrors();
      }
      catch (Exception e)
      {
         System.out.println ("DOM validation Exception: " + e.getMessage());
         return;
      }
      System.out.println("The input file <"+xmlURI+"> validated without errors");
   }
}
